/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.builder;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.PositionAnchor;
import icyllis.flexmark.util.sequence.Range;
import icyllis.flexmark.util.sequence.builder.CharRecoveryOptimizer;
import icyllis.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import icyllis.flexmark.util.sequence.builder.SegmentBuilderBase;
import icyllis.flexmark.util.sequence.builder.SegmentOptimizer;

public class BasedSegmentBuilder
extends SegmentBuilderBase<BasedSegmentBuilder>
implements IBasedSegmentBuilder<BasedSegmentBuilder> {
    @NotNull
    final BasedSequence baseSeq;
    @NotNull
    final SegmentOptimizer optimizer;

    protected BasedSegmentBuilder(@NotNull BasedSequence baseSeq) {
        this(baseSeq, new CharRecoveryOptimizer(PositionAnchor.CURRENT));
    }

    protected BasedSegmentBuilder(@NotNull BasedSequence baseSeq, @NotNull SegmentOptimizer optimizer) {
        this.baseSeq = baseSeq.getBaseSequence();
        this.optimizer = optimizer;
    }

    protected BasedSegmentBuilder(@NotNull BasedSequence baseSeq, int options) {
        this(baseSeq, new CharRecoveryOptimizer(PositionAnchor.CURRENT), options);
    }

    protected BasedSegmentBuilder(@NotNull BasedSequence baseSeq, @NotNull SegmentOptimizer optimizer, int options) {
        super(options);
        this.baseSeq = baseSeq.getBaseSequence();
        this.optimizer = optimizer;
    }

    @Override
    @NotNull
    public BasedSequence getBaseSequence() {
        return this.baseSeq;
    }

    @Override
    protected Object[] optimizeText(@NotNull Object[] parts) {
        return this.optimizer.apply(this.baseSeq, parts);
    }

    @Override
    protected Object[] handleOverlap(@NotNull Object[] parts) {
        Range overlap;
        Range lastSeg = (Range)parts[0];
        CharSequence text = (CharSequence)parts[1];
        Range range = (Range)parts[2];
        assert (!lastSeg.isNull() && lastSeg.getEnd() > range.getStart());
        Range after = Range.NULL;
        if (range.getEnd() <= lastSeg.getStart()) {
            overlap = range;
        } else if (range.getStart() <= lastSeg.getStart()) {
            overlap = Range.of(range.getStart(), Math.min(range.getEnd(), lastSeg.getEnd()));
            if (lastSeg.getEnd() < range.getEnd()) {
                after = Range.of(lastSeg.getEnd(), range.getEnd());
            }
        } else if (range.getEnd() <= lastSeg.getEnd()) {
            overlap = range;
        } else {
            assert (range.getStart() < lastSeg.getEnd());
            overlap = range.withEnd(lastSeg.getEnd());
            after = range.withStart(lastSeg.getEnd());
        }
        int overlapSpan = overlap.getSpan();
        assert (overlapSpan + after.getSpan() == range.getSpan());
        parts[1] = text.length() == 0 ? this.baseSeq.subSequence(overlap.getStart(), overlap.getEnd()).toString() : text.toString() + this.baseSeq.subSequence(overlap.getStart(), overlap.getEnd()).toString();
        parts[2] = after;
        return parts;
    }

    @Override
    @NotNull
    public String toStringWithRangesVisibleWhitespace() {
        return super.toStringWithRangesVisibleWhitespace(this.baseSeq);
    }

    @Override
    @NotNull
    public String toStringWithRanges() {
        return super.toStringWithRanges(this.baseSeq);
    }

    @Override
    @NotNull
    public String toStringChars() {
        return super.toString(this.baseSeq);
    }

    @NotNull
    public static BasedSegmentBuilder emptyBuilder(@NotNull BasedSequence sequence) {
        return new BasedSegmentBuilder(sequence);
    }

    @NotNull
    public static BasedSegmentBuilder emptyBuilder(@NotNull BasedSequence sequence, int options) {
        return new BasedSegmentBuilder(sequence, options);
    }

    @NotNull
    public static BasedSegmentBuilder emptyBuilder(@NotNull BasedSequence sequence, @NotNull SegmentOptimizer optimizer) {
        return new BasedSegmentBuilder(sequence, optimizer);
    }

    @NotNull
    public static BasedSegmentBuilder emptyBuilder(@NotNull BasedSequence sequence, @NotNull SegmentOptimizer optimizer, int options) {
        return new BasedSegmentBuilder(sequence, optimizer, options);
    }
}

